s                @                                      tkvx433X    Tek VX433X/VX437X Master/Slave Scanner        '     Instrument Name: Tek VX433x/VX437x Master/Slave
                  Scanner Module

 Description:   This instrument module provides
                programming support for the
                Tektronics VX4332/VX4334 Scanner
                Masters and the VX4372/VX4374
                Scanner Slaves. The module is
                divided into the following
                functions/classes:

 Functions/Classes:

 (1) Initialize
     Initialize the instrument and set to default
     configuration.

 (2) Configure
     This routines allow the control of the
     scanner system by allowing to set different
     delays for the different modules, triggers,
     interrupt generation, close relay commands,
     etc.

    (2a) Join Module
         Joins or disjoins the A and B sections of
         any of the modules making up the system.

    (2b) Switch Relays
         Opens or closes any relay in any module.

    (2c) Change Delay Times
         Sets the time it takes for the instrument
         to process another command after a close
         or open relay command.

    (2d) Set Interrupts
         Sets the instrument to interrupt its VXI
         commander with a Request True interrupt
         for a variety of conditions.

    (2e) Set Triggers
         Disables or defines a specific VXIbus TTL
         trigger line for trigger in and trigger
         out commands and conditions.

 (3) Program Routines
     This routines allow programming the
     instrument.  The program that the module can
     store is a command sequence using any of the
     commands and routines in this instrument
     driver.  This program can then be executed
     using the continue/step function.

    (3a) Input Program
         Sets the instrument in Program Mode.

    (3b) End Program
         Terminates the Program Input Mode.

    (3c) Run Program
         Starts execution of the program in the
         instrument's memory.

    (3d) Pause Program
         Pauses Program Mode.

    (3e) Continue/step Program
         Causes the instrument to continue after
         it is pauses or to execute a desired
         number of steps.

 (4) Low Level Routines
     This routines perform low level functions
     such as reseting the instrument to its
     power-up conditions, setting a wait time
     within the instrument, and listing errors
     from the instrument.

    (4a) Set Time Out
         Sets the time out for the instrument card
         being used (GPIB or VXI).

    (4b) Reset
         Resets the instrument to its power-up
         conditions.

    (4c) Wait
         Causes the instrument to wait a certain
         number of milliseconds before processing
         the next command.

    (4d) List Errors
         Queries the instrument to see if any
         errors have ocurred.

 (5) Close
     Take the instrument offline.          Panel Name:    Initialize

 Description:   This routine performs the
                following initialization actions:

                -  Opens the instrument by
                   storing information about the
                   instrument in the Instrument
                   Table.

                -  Initializes the VXI interface
                   (NI-VXI or NI-GPIB)
                   accordingly.

                -  Performs an identification
                   query on the Instrument.

                -  Sends initialization commands
                   to the instrument.

                -  Returns an Instrument ID which
                   is used to differentiate
                   between instruments of the same
                   model type.  This value will be
                   used to identify the instrument
                   in subsequent calls.

                -  Counts the number of modules
                   and the number of relays per
                   module present in the system.

         Class Name:    Configure

 Description:   This routines allow the control of
                the scanner system by allowing to
                set different delays for the
                different modules, triggers,
                interrupt generation, close relay
                commands,etc.  These Configure
                routines are:

     (1) Join Modules
         Joins or disjoins sections A and B of any
         module in the system.

     (2) Switch Relays
         Opens or closes any relays in the scanner
         system.

     (3) Change Delay Times
         Changes the time it takes for a module to
         accept another command after opening or
         closing a relay.

     (4) Set Interrupts
         Enables or disables generating a Request
         True interrupt on the VXIbus on the
         ocurrence of various events.

     (5) Set Triggers
         Disables or defines a specific VXIbus TTL
         trigger line for trigger in and trigger
         out commands and conditions.    z     Panel Name:    Join Modules

 Description:   This routine is able to join or
                disjoin the sections A and B of
                any of the modules present.

 Note:          Performing a Join or Disjoin
                command on any of the modules in
                the scanning system will open all
                closed relays in all modules, not
                only in the module being joined or
                disjoined.
                When a module is joined, closing a
                relay in its A section will
                automatically open any closed
                relay in either section A or B.
         Panel Name:    Switch Relays

 Description:   This routine is able to perform
                any of the following actions:

                -  Open or close any relay
                   on any of the modules.

                -  Open relays in all modules
                   except the relays joining the A
                   and B sections of each module,
                   which are not affected.         Panel Name:    Change Delay Times

 Description:   This routine is able to perform
                any of the following actions:

                -  Set the time a specific module
                   will delay accepting another
                   command after receiving a
                   command to close or open a
                   relay.

                -  Set the time that all modules
                   will delay accepting another
                   command after receiving a
                   command to close or open a
                   relay.

                If another command is send to the
                instrument before the set delay
                time has expired, the platform
                being used (GPIB or VXI) will have
                to have a sufficiently long time
                out set to be able to keep this
                next command until the instrument
                is able to accept it. The Set Time
                Out Routine can be used to adjust
                this time out.         Panel Name:    Set Interrupts

 Description:   This routine is able to perform
                several types of interrupts
                commands which enable or disable
                generating a Request True
                interrupt on the VXIbus on the
                ocurrence of various events.

 Note:          If this set of commands is used,
                the user should take care of
                acknowledging the interrupts.
          Panel Name:    Set Triggers

 Description:   This routine is able to disable or
                define a specific VXIbus TTL
                trigger line for trigger in and
                trigger out commands and
                conditions.
         Class Name:    Program Routines

 Description:   These routines allow programming
                the instrument.  The program
                that the module can store is a
                command sequence using any of the
                commands and routines in this
                instrument driver.  These Program
                Routines are:

     (1) Input Program
         Sets the instrument in Program Mode.

     (2) End Program
         Terminates the Program Input Mode.

     (3) Run Program
         Starts execution of the program in the
         instrument's memory.

     (4) Pause Program
         Pauses Program Mode.

     (5) Continue/step Program
         Causes the instrument to continue after
         it is paused or to execute a desired
         number of steps.

 Note:          An overflow message will be
                displayed on the front panel of
                the instrument and a software
                error will be generated if the
                instrument memory was exceeded
                while inputing a program.  It will
                continue to accept program input
                until the End Program is received
                but the entire program will be
                ignored.  Also, after turning off
                the instrument or doing a reset,
                any program stored in the
                instrument memory will be erased.         Panel Name:    Input Program

 Description:   This routine causes the instrument
                to store all commands received
                after the Input Program command
                into its memory for execution
                later.

 Note:          An Input Program command is not
                valid as part of a program
                definition (should not appear
                between an Input Program and an
                End Program command).
     r     Panel Name:    End Program

 Description:   This routine terminates the Input
                Program command.
    H     Panel Name:    Run Program

 Description:   This routine causes the instrument
                to execute the sequence of
                commands stored in it with the
                Input Program command.

 Note1:         If any command is sent to the
                instrument while the program is
                running, the program will be
                terminated at the end of the
                currently executing step and the
                new command is executed.  The
                program is then in a pause mode
                and may be continued using the
                Continue/step command.

 Note2:         A Run Program command is not
                valid as part of a program
                definition (should not appear
                between Input Program and End
                Program command).
         Panel Name:    Pause Program

 Description:   This routine causes an executing
                program to be paused. Using the
                Continue/step Program command will
                continue execution of the program.

 Note:          A Pause Program command is only
                valid as part of a program
                definition (is only valid when
                included between an Input Program
                and an End Program command).         Panel Name:    Continue/step Program

 Description:   This routine causes the instrument
                execute the program stored in its
                memory one or more steps at a time
                or to continue a paused program.

 Note:          A Continue/step Program command is
                not valid as part of a program
                definition(should not appear
                between Input Program and End
                Program command).
         Class Name:    Low Level Routines

 Description:   This routines perform low level
                functions such as resetting the
                instrument to its power-up
                conditions, setting a wait time
                within the instrument, listing
                errors from the instrument and
                setting the time out for the
                platform used (GPIB or VXI).
                These Low Level Routines are:

     (1) Set Time Out
         Sets the time out for the platform being
         used (GPIB or VXI).

     (2) Reset
         Resets the instrument to its power-up
         condition.

     (3) Wait
         Causes the instrument to wait a specified
         amount of time before accepting another
         command.

     (4) List Error
         Queries the error queue of the instrument
         and the first error in the queue if it
         exists.    q     Panel Name:    Set Time Out

 Description:   This routine sets the time out for
                for the platform being used (GPIB
                or VXI). See note below.

 Note:          The way this instrument handles
                relay switching with timing is
                the following:

                Say relay 1 in module 0 has been
                closed,  then, if relay 2 is to be
                closed, relay 1 must be opened
                first.  Therefore the time it will
                take for relay 2 to be closed is
                the opentime of relay 1.

                Also, after closing relay 2, a
                time equal to the closetime of
                relay 2 must pass before the
                instrument can accept another
                command for execution.

                In addition, when using the Wait
                Routine,the platform's time out
                should be greater than the wait
                time so that commands are not
                lost while the wait time is in
                effect.

                So if the time out of the
                platform being used (GPIB or VXI)
                is less than any of these times,
                some of the commands will not be
                executed since the platform will
                suffer a time out and commands may
                be lost.         Panel Name:    Reset

 Description:   This routine resets the instrument
                to its power-up condition:

                -  All relays are opened including
                   the join relays.

                -  All relay delay values are set
                   to their default values.

                -  All program information is
                   lost (ie. any program stored in
                   the instrument's memory using
                   the Program Routines will be
                   erased).

 Note:          A Reset Program command is not
                valid as part of a program
                definition (should not appear
                between Input Program and End
                Program command).         Panel Name:    Wait

 Description:   This routine causes the instrument
                to wait a specified amount of time
                before accepting another command.

 Note:          To prevent the interface being
                used (GPIB or VXI) from suffering
                a time out, the interface's time
                out should be adjusted using the
                Set Time Out function.

    5     Panel Name:    List Errors

 Description:   This routine queries the error
                queue of the instrument and it
                will return an error message if an
                error has occurred since the last
                time this function was called.
                The error message queue has a
                limit of 10 messages therefore, if
                an overflow occurs, new messages
                will be lost but an overflow error
                will be added to the queue.  One
                error message is returned per call
                to this routine.

Note:           A List Errors command is not valid
                as part of a program definition
                (should not appear between an
                Input Program and End Program
                command).
          Panel Name:     Close

 Description:    The close routine performs the
                 following operations:

                 -  removes the entry for the
                    instrument from the Instrument
                    Table.    1     Control Name:   Logical Address

 Description:    Specifies the Logical Address of
                 the VXI instrument.  This value
                 must corrrespond to the current
                 internal setting of the
                 instrument.

 Variable Type:  Integer

 Valid Range:    0 - 255         Control Name:  Interface

 Description:   Specifies which protocol is used
                to communicate with the VXI
                mainframe.

                NI-VXI should be selected for
                MC-MXI, AT-MXI, or VXIpc-386.

                NI-GPIB should be selected for the
                GPIB-VXI.

 Variable Type: Integer

 Valid Range:   1 - NI-VXI
                2 - NI-GPIB    0     Control Name:  Instrument ID

 Description:   Returns an Instrument ID that is
                used in all subsequent function
                calls to select the instrument at
                the address specified.

                If more than one instrument of the
                same model type is used, this ID
                will be used to differentiate
                between them. The first instrument
                of this model type initialized
                will be assigned an Instrument ID
                of 1.

 Variable Type: Integer          Control Name:  Scanner Master Type

 Description:   Specifies the type of Master
                Scanner to be initialized.

 Variable Type: Integer

 Valid Range:   0 -  TK_VX4332
                1 -  TK_VX4334    r     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Logical Address out of range
       -2   Interface out of range
       -4   Master Scanner type out of range

      220   Unable to open instrument
      222   Unable to initialize VXI library
      223   Instrument ID query failed
      230   Error writing to instrument
      231   Error reading from instrument
      233   Error configuring GPIB address
      236   Error interpreting instrument response
      241   Error configuring repeat addressing    ?p X =           Logical Address                   @ X           Select Interface                  BA Xc          Instrument ID                     Dy            Master Scanner Type               EW          Error                           ,                                             1   NI-VXI 1 NI-GPIB 2    	            TK_VX4332 0 TK_VX4334 1    	            FCopyright 1993 National Instruments Corporation.
All Rights Reserved.         Control Name:  Function

 Description:   Specifies whether the module
                will be joined or disjoined.

 Variable Type: Integer

 Valid Range:   0 - disjoin module
                1 - join module    Y     Control Name:  Module Number

 Description:   Specifies the module whose
                sections A and B should be joined
                or disjoined.

 Variable Type: Integer

 Valid Range:   The instrument is module #0. The
                slave immediately to the right
                is module #1, the next slave
                is module #2, and so on.

 Note:          The instrument can control up to
                11 slave modules.  Each module
                that has a slave to its right
                must have its Local Bus Out Enable
                switches enabled (closed).
    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    e     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range
       -2   Module number out of range
       -3   Function number out of range

      230   Error writing to instrument
      232   Instrument not initialized    I X           Function                          J X2          Module Number                     L             Instrument ID                     O0          Error                              join 1 disjoin 0    0    1    	           U     Control Name:  Module Number

 Description:   This is the number of the module
                where the relay to be switched is
                located.

 Variable Type: Integer

 Valid Range:   The instrument is module #0. The
                slave immediately to the right
                is module #1, the next slave
                is module #2, and so on.

 Note:          The instrument can control up to
                11 slave modules.  Each module
                that has a slave to its right
                must have its Local Bus Out Enable
                switches enabled.




    b     Control Name:  Function

 Description:   Specifies one of the following
                actions:

                -  Close or open a specific relay.

                -  Open the relays in all modules.

 Variable Type: Integer

 Valid Range:   0 - open a specific relay
                1 - open all relays in all modules
                    but join relays are not
                    affected
                2 - close a specific relay

 Note:          The Open All command does not
                affect the relays that join the A
                and B sections together.
                sections together         Control Name:  Relay Number

 Description:   Specifies the relay to be opened
                or closed. This parameter is
                ignored if function "open all" is
                selected.

 Variable Type: Integer

 Valid Range:   The number of relays in a module
                will depend on its serial number.
                Read the manual of each module to
                find how many relays it contains.
                The valid relay numbers are then
                0 to (number of relays -1).
                The tkvx4332 for example, is
                made up of two sections (A and B),
                each having 20 channels therefore
                the valid range of relay numbers
                is 0 to 39.
    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range
       -2   Module number out of range
       -3   Function number out of range
       -4   Relay number out of range


      230   Error writing to instrument
      232   Instrument not initialized    Q X Y          Module Number                     S X          Function                          Vb Xx          Relay Number                      YQ             Instrument ID                     [          Error                              0               open 0 open all 1 close 2        1    	           
     Control Name:  Function

 Description:   Specifies one of the following
                actions:

                -  Change the open or close delay
                   times of a specific module.

                -  Change the open or close delay
                   times of all the modules to
                   the same time.

 Variable Type: Integer

 Valid Range:   0 - change the open delay time for
                    relays of a specific module.
                1 - change the open delay times
                    for the relays in all modules.
                2 - change the close delay time
                    for relays of a specific
                    module.
                3 - change the close delay times
                    for the relays in all modules.


    2     Control Name:  Module Number

 Description:   Specifies the module whose delay
                times are to be changed.

 Variable Type: Integer

 Valid Range:   The instrument is module #0. The
                slave immediately to the right
                is module #1, the next slave
                is module #2, and so on.

 Note:          The instrument can control up to
                11 slave modules.  Each module
                that has a slave to its right
                must have its Local Bus Out Enable
                switches enabled.



    (     Control Name:  Delay (millisec)

 Description:   Specifies the new value to which
                the delay time is to be changed.

 Variable Type: Integer

 Valid Range:   Minimum value = 1000 millisec
                Maximum value = 32767  millisec
                              = 32.767 sec    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range
       -2   Function number out of range
       -3   Module number out of range
       -4   Delay time out of range

      230   Error writing to instrument
      232   Instrument not initialized    ^ h ~          Function                          a h           Module Number                     c hj         Delay (millisec)                  d             Instrument ID                     gK          Error                                         5opentime 0 opentime all 1 closetime 2 closetimeall 3    0    1000    1    	                Control Name:  Type

 Description:   Specifies one of the following
                types of interrupts:

        User1:  To cause a Request True Interrupt
                to occur in the VXIbus when the
                instrument receives this command.

        User2:  To cause a Request True Interrupt
                to occur in the VXIbus when the
                instrument receives this command.

 Relay Closed:  To enable or disable a Request
                True Interrupt after a relay has
                been closed and the relay close
                delay time has expired.

 Program Done:  To enable or disable a Request
                True Interrupt at the end of a
                program.

        Error:  To enable or disable a Request
                True Interrupt for any of three
                error conditions:

                (1) a relay failed to open after
                    the relay open delay.

                (2) a relay failed to close after
                    the relay close delay.

                (3) a syntax error was detected.

   Trigger_in:  To enable or disable Request True
                Interrupt when a trigger is
                detected.

 Variable Type: Integer

 Valid Range:   0 - User1 interrupt
                1 - User2 interrupt
                2 - Relay Closed interrupt
                3 - Program Done interrupt
                4 - Error interrupt
                5 - Trigger_in interrupt    E     Control Name:  Interrupt

 Description:   Specifies whether the interrupt is
                to be enabled or disabled.  This
                parameter is ignored if User1 or
                User2 interrupts are selected.

 Variable Type: Integer

 Valid Range:   0 - Interrupt disable
                1 - Interrupt enable    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range
       -2   Interrupt Type out of range
       -3   interrupt enable/disable function out
            of range

      230   Error writing to instrument
      232   Instrument not initialized    jG H           Type                              p H          Interrupt                         qN             Instrument ID                     s          Error                                         CUser1 0 User2 1 Relay Closed 2 Program Done 3 Error 4 Trigger_in 5   Enable 1 Disable 0    1    	                Control Name:  Trigger Type

 Description:   Specifies one of the following
                trigger-related events to occur:

          T_in: selects the VXIbus trigger line
                specified in T_Line Number to be
                monitored by the instrument when
                executing a T_Wait trigger
                command.

 T_in disabled: disables the T_in trigger command.

         T_out: selects the VXIbus TTL trigger
                line specified in T_Line Number
                to be triggered when a relay
                switch is closed or a Trigger1 or
                Trigger2 command is received.

 T_out disable: disables the T_out trigger
                command.

      Trigger1: triggers the VXIbus TTL trigger
                line specified in T_Line Number.

      Trigger2: triggers the VXIbus TTL trigger
                line selected by the T_out
                command. In this case, the next
                parameter, T_Line Number, is not
                used.

        T_Wait: causes the instrument to wait for
                a VXIbus TTL trigger line pulse on
                the line selected by the T_in
                command before processing any
                additional commands.

 Variable Type: Integer

 Valid Range:   0 - Trigger_in
                1 - Trigger_in disabled
                2 - Trigger_out
                3 - Trigger_out disabled
                4 - Trigger1
                5 - Trigger2
                6 - Trigger_wait    '     Control Name:  T_Line Number

 Description:   Specifies the VXIbus trigger line
                that will be included with the
                trigger command specified under
                the second parameter (Trigger
                Type).

 Variable Type: Integer

 Valid Range:   0 to 7    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    a     Control Name:  Error

 Description:   Displays status relating to the
               function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range
       -2   Trigger Type out of range
       -3   T_Line Number out of range

      230   Error writing to instrument
      232   Instrument not initialized    vv X           Trigger Type                      |[ X         Trigger Line Number               }             Instrument ID                               Error                                         LT_in 0 T_in disable 1 T_out 2 T_out disabl 3 Trigger1 4 Trigger2 5 T_Wait 6                          1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
               function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized                 Instrument ID                               Error                              1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
               function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized                 Instrument ID                               Error                              1    	                Control Name:  Repetitions

 Description:   Specifies the number of times that
                a program will be executed.

 Variable Type: Integer

 Valid Range:   0 to 32767


 Note1:         If repetitions is set to 0, the
                program will be repeated until
                stopped.  The program will be
                stopped and any closed relays will
                be opened by one of the following
                events:
                  - a VXIbus system reset.
                  - a VXI Abort Normal Operation.
                  - a VXI End Normal Operation.
                  - any hardware or sytax error.

 Note2:         If another command is sent to the
                instrument, the program is
                terminated at the end of the
                currently executing step and the
                new command is executed.  The
                program is then in a pause mode
                and may be continued with the
                "continue/step program" command.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    9     Control Name:  Error

 Description:   Displays status relating to the
               function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range
       -2   Repetitions out of range

      230   Error writing to instrument
      232   Instrument not initialized    e h           Repetitions                       b             Instrument ID                               Error                              1    1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized                 Instrument ID                               Error                              1    	           }     Control Name:  Steps

 Description:   Specifies the number of steps to
                be executed within a program
                starting from the beginning of the
                program or from where the program
                is currently paused.  Setting
                steps to 0 sets the number of
                Steps to infinity.  See Note1
                below.

 Variable Type: Integer

 Valid Range:   0 to 32767

 Note1:         Setting Steps to 0 can result in
                one of the following actions to be
                taken:
                -  If the program is in pause
                   mode, it will continue to
                   execute from the point it was
                   paused. Execution will continue
                   until the original loop count
                   is completed, another "pause
                   program" command is
                   encountered, or another command
                   is sent to the instrument.

 Note2:         Setting Steps to a value greater
                than the number of steps left to
                execute will not extend the
                program.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    4     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range
       -2   Steps out of range

      230   Error writing to instrument
      232   Instrument not initialized     h           Steps                                          Instrument ID                     b          Error                              1    1    	                Control Name:  Time Out

 Description:   Specifies the Time Out of the
                interface being used. The value
                entered represents a time out
                which depends on the interface
                used.  Refer to the following
                table of codes to decide which
                Time Out Code to enter.

                           _____TIME OUT____
      Time Out Code        GPIB          VXI
           0           0 (disabled)       0
           1                10 us         1 ms
           2                30 us         1 ms
           3               100 us         1 ms
           4               300 us         1 ms
           5                 1 ms         1 ms
           6                 3 ms         3 ms
           7                10 ms        10 ms
           8                30 ms        30 ms
           9               100 ms       100 ms
          10               300 ms       300 ms
          11                 1 s          1 s
          12                 3 s          3 s
          13                10 s         10 s
          14                30 s         30 s
          15               100 s        100 s
          16               300 s        300 s
          17              1000 s       1000 s

 Note:          The 1 sec time outs for the VXI
                case (Time Out Codes 1 through 5)
                are approximate.

 Variable Type: Integer

 Valid Range:   0 to 17.    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
               function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range
       -2   Time Out Code out of range

      239   Error in configuring timeout    S x           Time Out Code                                  Instrument ID                     [          Error                              14    1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
               function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range

      230   Error writing to instrument
      232   Instrument not initialized    .             Instrument ID                     }          Error                              1    	           E     Control Name:  Wait time (millisec)

 Description:   Specifies the time the instrument
                will wait before accepting the
                next command.

 Variable Type: Integer

 Valid Range:   Minimum value = 0 millisec
                Maximum value = 32767 millisec
                              = 32.767 sec    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    8     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range
       -2   Wait time out of range

      230   Error writing to instrument
      232   Instrument not initialized     h           Wait Time (millisec)              a             Instrument ID                               Error                              0    1    	                Control Name:  Error Message

 Description:   Returns an error message each time
                it is called. Error messages are
                thrown away as they are read. If
                the returned value is blank, no
                errors have occurred.
                See appendixes of the tkvx433X
                Scanner Module Operating Manual
                for a list of the possible error
                messages.

 Variable Type: String

 Length:        50    G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.    ?     Control Name:  Error

 Description:   Displays status relating to the
                function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range

      230   Error writing to instrument
      231   Error writing from instrument
      232   Instrument not initialized     h          Error Message                                  Instrument ID                               Error                              	            1    	           G     Control Name:  Instrument ID

 Description:   Accepts the Instrument ID returned
                by the Initialize function to
                select the desired instrument.

 Variable Type: Integer

 Valid Range:   1  to  Maximum Instances of
                       this Instrument

                The Maximum Instances of this
                Instrument is the maximum number
                instruments that can be controlled
                by this driver in a single system.
                The value is set internally in the
                driver. The typical value is 10.         Control Name:  Error

 Description:   Displays status relating to the
               function call.

 Variable Type: Integer

 Errors:
        0   Success
       -1   Instrument ID out of range

      221   Unable to close device
      232   Device not initialized                 Instrument ID                     /          Error                              1    	                    G     K.    init                                       P     K.    joinmodule                        :         ]4     K.    switchrelays                               h     K.    changedelaytimes                           u)     K.    set_interrupts                             B     K.    set_triggers                      $B              K.    input_program                     &"              K.    end_program                       &              K.    run_program                       )              K.    pause_program                     +              K.    step_program                      14         x     K.    set_timeout                       6              K.    reset                             9              K.    wait                              ;>         $     K.    list_error                        >{         B     K.    close                                                                       DInitialize                          Configure                            DJoin Module                          DSwitch Relays                        DChange Delay Times                   DSet Interrupts                       DSet Triggers                        Program Routines                     DInput Program                        DEnd Program                          DRun Program                          DPause Program                        DContinue/step Program               -Low Level Routines                   DSet Time Out                         DReset                                DWait                                 DList Error                           DClose                           